// Created by Newton Book Maker 1.1
//  Note: This file may contain needed resources !! 
// Document
book := {
	version: 2,
	isbn: "ISBN4:50:02 AM",
	help: TRUE,
	contents: Array(14, NIL),
	styles: [],
	browsers: [], templates: [], rendering: []};
//output.book := book;
//output.help := TRUE;

// Shared Map Functions
func MakePage(aTemplate)
	{template: aTemplate, blocks: []};
func MakeBlock(aBounds, anItem)
	{bounds: aBounds, item: anItem};

// Shared Scripts
gotoDestScript := func() begin
	if (curRendering = 0) then :TurnToPage(destPage);
	else :TurnToPage(:FindPageByContent(kioskDest, 0, NIL));
end;

// Text Styles
s0 := {
	family: 'Geneva,
	face: 0,
	size: 9};
AddArraySlot(book.styles, s0);

s1 := {
	family: 'espy /* Monaco */,
	face: 0,
	size: 10};
AddArraySlot(book.styles, s1);

s2 := {
	family: 'Espy,
	face: 1,
	size: 14};
AddArraySlot(book.styles, s2);

s3 := {
	family: 'Espy,
	face: 1,
	size: 10};
AddArraySlot(book.styles, s3);

s4 := {
	family: 'Espy,
	face: 0,
	size: 10};
AddArraySlot(book.styles, s4);


// Contents
c1 := {
	data: "Use the EnRoute Rule Editor",
	viewFont: s3,
	layout: 32
};
book.contents[0] := c1;

c2 := {
	data: "This online help book describes how to use the EnRoute Rule Editor. Please refer to the printed manual for more detailed information.

The Rule Editor is an application supplied with EnRoute i-net that is filed under Setup in the Extras Drawer.

For your convenience you may also access the Rule Editor from the Rules Filter plug-in by tapping the \"Rule Editor\" button.
",
	viewFont: s4
};
book.contents[1] := c2;

c3 := {
	data: "Use Rules",
	viewFont: s3,
	layout: 32
};
book.contents[2] := c3;

c4 := {
	data: "The EnRoute Rule Editor is used to create Rule Sets for use with the companion Message Rules Filter plug-in.

The Message Rules Filter can tell EnRoute i-net to accept and reject email messages based on a rich set of criteria which you define with the Rule Editor.

After Rule sets have been created, the Rule Editor does not need to be available for the Message Rules Filter to work.
",
	viewFont: s4
};
book.contents[3] := c4;

c5 := {
	data: "Create New Rules",
	viewFont: s3,
	layout: 32
};
book.contents[4] := c5;

c6 := {
	data: "To create an empty Rule Set, tap the New button at the bottom of the Rule Editor. A blank stationary view will open with an Untitled Rule Set.

To create a new Rule Item in the Rule stationary, tap the rule button centered at the bottom of the stationary view. A Rule slip will open to allow you to specify the Rule criteria.
",
	viewFont: s4
};
book.contents[5] := c6;

c7 := {
	data: "Specify the Rule Criteria",
	viewFont: s3,
	layout: 32
};
book.contents[6] := c7;

c8 := {
	data: "On the Rule slip, you will find three diamond popup menus and one text entry line. The first two diamonds and the entry line compose the \"if\" part of an if/then statement. The choice that you make in the first menu will determine the other choices made available to you.

One or more Rules generated on the Rules Stationary slip are referred to as a Rule Set. You may create a maximum of twenty-four Rules in each set.
",
	styles: [419, s4, 1, s1]
};
book.contents[7] := c8;

c9 := {
	data: "Arrange Rule Items",
	styles: [18, s3, 1, s4],
	layout: 32
};
book.contents[8] := c9;

c10 := {
	data: "Each Rule Set is a hierarchy, and the order of the Rules is very important. An incoming message will be tested against the first Rule in the set. If the Rule is triggered, the remaining Rules will not be used.

To alter the hierarchy of the Rule Set, tap on the bullet of the Rule you wish to move and drag it to its new location.

To delete a Rule item, scrub it out by drawing a zigzag line over it.
",
	viewFont: s4
};
book.contents[9] := c10;

c11 := {
	data: "Name and File Rule Sets",
	styles: [23, s3, 1, s4],
	layout: 32
};
book.contents[10] := c11;

c12 := {
	data: "Once a Rule Set has been defined, you should name it for future use.

Name the Rule Set by tapping the Picture button in the upper-left corner.

File the Rule Set by tapping the Folder button in the lower-right corner.

EnRoute i-net allows you to select one Rule Set at a time (by name) and to enable or disable the entire Rule Filter.
",
	viewFont: s4
};
book.contents[11] := c12;

c13 := {
	data: "Use Advanced Features",
	styles: [21, s3, 1, s4],
	layout: 32
};
book.contents[12] := c13;

c14 := {
	data: "To use a Rule Set filed on a card, select the set from the Message Rules Filter before removing the card.

A message will be loaded if it does not trigger any Rules.  To prevent this, create a final rule in the set to skip messages if their size is greater than two bytes.

To read the POP List Manager headers without loading any messages, create a Rule Set with a single Rule to skip messages larger than two bytes.
",
	styles: [107, s4, 166, s1, 146, s4]
};
book.contents[13] := c14;


// Kiosk (menu page) references

// Page Templates
NBMDefault := {
	nColumns: 1,
	column: [{
	width: 12,
	type: 0}]
};
AddArraySlot(book.templates, NBMDefault);

// Bounds List
bnd1 := [0,0,206,14];
bnd2 := [0,14,206,214];
bnd3 := [0,0,206,28];

// Pages
pageList := {pageSize: {left: 0, top: 0, right: 206, bottom: 214}, pages: []};

// Page 1
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c1));
AddArraySlot(page.blocks, MakeBlock(bnd2, c2));
AddArraySlot(pageList.pages, page);

// Page 2
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c3));
AddArraySlot(page.blocks, MakeBlock(bnd2, c4));
AddArraySlot(pageList.pages, page);

// Page 3
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c5));
AddArraySlot(page.blocks, MakeBlock(bnd2, c6));
AddArraySlot(pageList.pages, page);

// Page 4
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c7));
AddArraySlot(page.blocks, MakeBlock(bnd2, c8));
AddArraySlot(pageList.pages, page);

// Page 5
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c9));
AddArraySlot(page.blocks, MakeBlock(bnd2, c10));
AddArraySlot(pageList.pages, page);

// Page 6
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c11));
AddArraySlot(page.blocks, MakeBlock(bnd2, c12));
AddArraySlot(pageList.pages, page);

// Page 7
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c13));
AddArraySlot(page.blocks,
	{bounds: bnd2,
	item: c14,
	dataLen: 386});
AddArraySlot(pageList.pages, page);

// Page 8
page := MakePage(NBMDefault);
AddArraySlot(page.blocks,
	{bounds: bnd3,
	item: c14,
	dataOffset: 386,
	dataLen: 31});
AddArraySlot(pageList.pages, page);

AddArraySlot(book.rendering, pageList);

// Browsers & Page Hints
b1 := {
	name: "Contents",  list: []
};


AddArraySlot(b1.list, {	// 0
	item: c1
});
AddArraySlot(b1.list, {	// 1
	item: c3
});
AddArraySlot(b1.list, {	// 2
	item: c5
});
AddArraySlot(b1.list, {	// 3
	item: c7
});
AddArraySlot(b1.list, {	// 4
	item: c9
});
AddArraySlot(b1.list, {	// 5
	item: c11
});
AddArraySlot(b1.list, {	// 6
	item: c13
});
AddArraySlot(book.browsers, b1);

// Indices and Sub-Indices
